# The PEP 484 type hints stub file for the krita module.
#
# Generated by SIP 6.6.2


import typing

import PyQt5.sip

from PyQt5 import QtWidgets
from PyQt5 import QtXml
from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class Shape(QtCore.QObject):

    def parentShape(self) -> 'Shape': ...
    def isSelected(self) -> bool: ...
    def deselect(self) -> None: ...
    def select(self) -> None: ...
    def toSvg(self, prependStyles: bool = ..., stripTextMode: bool = ...) -> str: ...
    def updateAbsolute(self, box: QtCore.QRectF) -> None: ...
    def update(self) -> None: ...
    def remove(self) -> bool: ...
    def absoluteTransformation(self) -> QtGui.QTransform: ...
    def setTransformation(self, matrix: QtGui.QTransform) -> None: ...
    def transformation(self) -> QtGui.QTransform: ...
    def setPosition(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...
    def boundingBox(self) -> QtCore.QRectF: ...
    def setGeometryProtected(self, protect: bool) -> None: ...
    def geometryProtected(self) -> bool: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def selectable(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def visible(self) -> bool: ...
    def setZIndex(self, zindex: int) -> None: ...
    def zIndex(self) -> int: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...


class GroupShape(Shape):

    def children(self) -> typing.List[Shape]: ...


class Canvas(QtCore.QObject):

    def view(self) -> 'View': ...
    def levelOfDetailMode(self) -> bool: ...
    def setLevelOfDetailMode(self, enable: bool) -> None: ...
    def wrapAroundMode(self) -> bool: ...
    def setWrapAroundMode(self, enable: bool) -> None: ...
    def setMirror(self, value: bool) -> None: ...
    def mirror(self) -> bool: ...
    def setRotation(self, angle: float) -> None: ...
    def rotation(self) -> float: ...
    def resetRotation(self) -> None: ...
    def resetZoom(self) -> None: ...
    def setZoomLevel(self, value: float) -> None: ...
    def zoomLevel(self) -> float: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Channel(QtCore.QObject):

    def setPixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], rect: QtCore.QRect) -> None: ...
    def pixelData(self, rect: QtCore.QRect) -> QtCore.QByteArray: ...
    def bounds(self) -> QtCore.QRect: ...
    def channelSize(self) -> int: ...
    def position(self) -> int: ...
    def name(self) -> str: ...
    def setVisible(self, value: bool) -> None: ...
    def visible(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class DockWidgetFactoryBase(PyQt5.sip.wrapper):

    class DockPosition(int):
        DockTornOff = ... # type: DockWidgetFactoryBase.DockPosition
        DockTop = ... # type: DockWidgetFactoryBase.DockPosition
        DockBottom = ... # type: DockWidgetFactoryBase.DockPosition
        DockRight = ... # type: DockWidgetFactoryBase.DockPosition
        DockLeft = ... # type: DockWidgetFactoryBase.DockPosition
        DockMinimized = ... # type: DockWidgetFactoryBase.DockPosition

    @typing.overload
    def __init__(self, _id: str, _dockPosition: 'DockWidgetFactoryBase.DockPosition') -> None: ...
    @typing.overload
    def __init__(self, a0: 'DockWidgetFactoryBase') -> None: ...

    def id(self) -> str: ...
    def createDockWidget(self) -> QtWidgets.QDockWidget: ...


class DockWidget(QtWidgets.QDockWidget):

    def __init__(self) -> None: ...

    def canvasChanged(self, canvas: Canvas) -> None: ...
    def canvas(self) -> Canvas: ...


class Document(QtCore.QObject):

    def removeAnnotation(self, type: str) -> None: ...
    def setAnnotation(self, type: str, description: str, annotation: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def annotation(self, type: str) -> QtCore.QByteArray: ...
    def annotationDescription(self, type: str) -> str: ...
    def annotationTypes(self) -> typing.List[str]: ...
    def setCurrentTime(self, time: int) -> None: ...
    def currentTime(self) -> int: ...
    def playBackEndTime(self) -> int: ...
    def playBackStartTime(self) -> int: ...
    def setPlayBackRange(self, start: int, stop: int) -> None: ...
    def animationLength(self) -> int: ...
    def fullClipRangeEndTime(self) -> int: ...
    def setFullClipRangeEndTime(self, endTime: int) -> None: ...
    def fullClipRangeStartTime(self) -> int: ...
    def setFullClipRangeStartTime(self, startTime: int) -> None: ...
    def setFramesPerSecond(self, fps: int) -> None: ...
    def framesPerSecond(self) -> int: ...
    def importAnimation(self, files: typing.Iterable[str], firstFrame: int, step: int) -> bool: ...
    def bounds(self) -> QtCore.QRect: ...
    def setModified(self, modified: bool) -> None: ...
    def modified(self) -> bool: ...
    def setGuidesLocked(self, locked: bool) -> None: ...
    def setGuidesVisible(self, visible: bool) -> None: ...
    def setVerticalGuides(self, lines: typing.Iterable[float]) -> None: ...
    def setHorizontalGuides(self, lines: typing.Iterable[float]) -> None: ...
    def refreshProjection(self) -> None: ...
    def tryBarrierLock(self) -> bool: ...
    def waitForDone(self) -> None: ...
    def unlock(self) -> None: ...
    def lock(self) -> None: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def projection(self, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QtGui.QImage: ...
    def createColorizeMask(self, name: str) -> 'ColorizeMask': ...
    def createTransformMask(self, name: str) -> 'TransformMask': ...
    def createTransparencyMask(self, name: str) -> 'TransparencyMask': ...
    def createSelectionMask(self, name: str) -> 'SelectionMask': ...
    @typing.overload
    def createFilterMask(self, name: str, filter: 'Filter', selection: 'Selection') -> 'FilterMask': ...
    @typing.overload
    def createFilterMask(self, name: str, filter: 'Filter', selection_source: 'Node') -> 'FilterMask': ...
    def createFileLayer(self, name: str, fileName: str, scalingMethod: str, scalingFilter: str = ...) -> 'FileLayer': ...
    def createVectorLayer(self, name: str) -> 'VectorLayer': ...
    def createFillLayer(self, name: str, filterName: str, configuration: 'InfoObject', selection: 'Selection') -> 'FillLayer': ...
    def createFilterLayer(self, name: str, filter: 'Filter', selection: 'Selection') -> 'FilterLayer': ...
    def createCloneLayer(self, name: str, source: 'Node') -> 'CloneLayer': ...
    def createGroupLayer(self, name: str) -> 'GroupLayer': ...
    def createNode(self, name: str, nodeType: str) -> 'Node': ...
    def saveAs(self, filename: str) -> bool: ...
    def save(self) -> bool: ...
    def shearImage(self, angleX: float, angleY: float) -> None: ...
    def rotateImage(self, radians: float) -> None: ...
    def scaleImage(self, w: int, h: int, xres: int, yres: int, strategy: str) -> None: ...
    def resizeImage(self, x: int, y: int, w: int, h: int) -> None: ...
    def flatten(self) -> None: ...
    def exportImage(self, filename: str, exportConfiguration: 'InfoObject') -> bool: ...
    def crop(self, x: int, y: int, w: int, h: int) -> None: ...
    def close(self) -> bool: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setYRes(self, yRes: float) -> None: ...
    def yRes(self) -> float: ...
    def setXRes(self, xRes: float) -> None: ...
    def xRes(self) -> float: ...
    def setYOffset(self, y: int) -> None: ...
    def yOffset(self) -> int: ...
    def setXOffset(self, x: int) -> None: ...
    def xOffset(self) -> int: ...
    def setWidth(self, value: int) -> None: ...
    def width(self) -> int: ...
    def setSelection(self, value: 'Selection') -> None: ...
    def selection(self) -> 'Selection': ...
    def rootNode(self) -> 'Node': ...
    def setResolution(self, value: int) -> None: ...
    def resolution(self) -> int: ...
    def setName(self, value: str) -> None: ...
    def name(self) -> str: ...
    def setHeight(self, value: int) -> None: ...
    def height(self) -> int: ...
    def setFileName(self, value: str) -> None: ...
    def fileName(self) -> str: ...
    def setDocumentInfo(self, document: str) -> None: ...
    def documentInfo(self) -> str: ...
    def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> bool: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setColorSpace(self, value: str, colorDepth: str, colorProfile: str) -> bool: ...
    def setColorProfile(self, colorProfile: str) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def nodeByUniqueID(self, id: QtCore.QUuid) -> 'Node': ...
    def nodeByName(self, node: str) -> 'Node': ...
    def topLevelNodes(self) -> typing.List['Node']: ...
    def setActiveNode(self, value: 'Node') -> None: ...
    def activeNode(self) -> 'Node': ...
    def clone(self) -> 'Document': ...
    def guidesLocked(self) -> bool: ...
    def guidesVisible(self) -> bool: ...
    def verticalGuides(self) -> typing.List[float]: ...
    def horizontalGuides(self) -> typing.List[float]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Filter(QtCore.QObject):

    def __init__(self) -> None: ...

    def startFilter(self, node: 'Node', x: int, y: int, w: int, h: int) -> bool: ...
    def apply(self, node: 'Node', x: int, y: int, w: int, h: int) -> None: ...
    def setConfiguration(self, value: 'InfoObject') -> None: ...
    def configuration(self) -> 'InfoObject': ...
    def setName(self, a0: str) -> None: ...
    def name(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class InfoObject(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def property(self, key: str) -> typing.Any: ...
    def setProperty(self, key: str, value: typing.Any) -> None: ...
    def setProperties(self, value: typing.Dict[str, typing.Any]) -> None: ...
    def properties(self) -> typing.Dict[str, typing.Any]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Extension(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createActions(self, window: 'Window') -> None: ...
    def setup(self) -> None: ...


class View(QtCore.QObject):

    def flakeToImageTransform(self) -> QtGui.QTransform: ...
    def flakeToCanvasTransform(self) -> QtGui.QTransform: ...
    def flakeToDocumentTransform(self) -> QtGui.QTransform: ...
    def selectedNodes(self) -> typing.List['Node']: ...
    def showFloatingMessage(self, message: str, icon: QtGui.QIcon, timeout: int, priority: int) -> None: ...
    def setPaintingFlow(self, flow: float) -> None: ...
    def paintingFlow(self) -> float: ...
    def setBrushRotation(self, brushRotation: float) -> None: ...
    def brushRotation(self) -> float: ...
    def setBrushSize(self, brushSize: float) -> None: ...
    def brushSize(self) -> float: ...
    def setPaintingOpacity(self, opacity: float) -> None: ...
    def paintingOpacity(self) -> float: ...
    def setHDRGamma(self, gamma: float) -> None: ...
    def HDRGamma(self) -> float: ...
    def setHDRExposure(self, exposure: float) -> None: ...
    def HDRExposure(self) -> float: ...
    def setCurrentBlendingMode(self, blendingMode: str) -> None: ...
    def currentBlendingMode(self) -> str: ...
    def setCurrentGradient(self, resource: 'Resource') -> None: ...
    def currentGradient(self) -> 'Resource': ...
    def setCurrentPattern(self, resource: 'Resource') -> None: ...
    def currentPattern(self) -> 'Resource': ...
    def setCurrentBrushPreset(self, resource: 'Resource') -> None: ...
    def currentBrushPreset(self) -> 'Resource': ...
    def setBackGroundColor(self, color: 'ManagedColor') -> None: ...
    def backgroundColor(self) -> 'ManagedColor': ...
    def setForeGroundColor(self, color: 'ManagedColor') -> None: ...
    def foregroundColor(self) -> 'ManagedColor': ...
    def activateResource(self, resource: 'Resource') -> None: ...
    def canvas(self) -> Canvas: ...
    def setVisible(self) -> None: ...
    def visible(self) -> bool: ...
    def setDocument(self, document: Document) -> None: ...
    def document(self) -> Document: ...
    def window(self) -> 'Window': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Window(QtCore.QObject):

    def activeViewChanged(self) -> None: ...
    def themeChanged(self) -> None: ...
    def windowClosed(self) -> None: ...
    def createAction(self, id: str, text: str = ..., menuLocation: str = ...) -> QtWidgets.QAction: ...
    def close(self) -> None: ...
    def activate(self) -> None: ...
    def activeView(self) -> View: ...
    def showView(self, view: View) -> None: ...
    def addView(self, document: Document) -> View: ...
    def views(self) -> typing.List[View]: ...
    def dockers(self) -> typing.List[QtWidgets.QDockWidget]: ...
    def qwindow(self) -> QtWidgets.QMainWindow: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Krita(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def getAppDataLocation() -> str: ...
    @staticmethod
    def krita_i18nc(context: str, text: str) -> str: ...
    @staticmethod
    def krita_i18n(text: str) -> str: ...
    @staticmethod
    def fromVariant(v: typing.Any) -> QtCore.QObject: ...
    @staticmethod
    def instance() -> 'Krita': ...
    def readSetting(self, group: str, name: str, defaultValue: str) -> str: ...
    def writeSetting(self, group: str, name: str, value: str) -> None: ...
    def addDockWidgetFactory(self, _factory: DockWidgetFactoryBase) -> None: ...
    def addExtension(self, _extension: Extension) -> None: ...
    def icon(self, iconName: str) -> QtGui.QIcon: ...
    def openWindow(self) -> Window: ...
    def openDocument(self, filename: str) -> Document: ...
    def extensions(self) -> typing.List[Extension]: ...
    def createDocument(self, width: int, height: int, name: str, colorModel: str, colorDepth: str, profile: str, resolution: float) -> Document: ...
    def recentDocuments(self) -> typing.List[str]: ...
    def resources(self, type: str) -> typing.Any: ...
    def windows(self) -> typing.List[Window]: ...
    def activeWindow(self) -> Window: ...
    def views(self) -> typing.List[View]: ...
    def version(self) -> str: ...
    def notifier(self) -> 'Notifier': ...
    def addProfile(self, profilePath: str) -> bool: ...
    def profiles(self, colorModel: str, ColorDepth: str) -> typing.List[str]: ...
    def filterStrategies(self) -> typing.List[str]: ...
    def colorDepths(self, colorModel: str) -> typing.List[str]: ...
    def colorModels(self) -> typing.List[str]: ...
    def filter(self, name: str) -> Filter: ...
    def filters(self) -> typing.List[str]: ...
    def dockers(self) -> typing.List[QtWidgets.QDockWidget]: ...
    def documents(self) -> typing.List[Document]: ...
    def action(self, name: str) -> QtWidgets.QAction: ...
    def actions(self) -> typing.List[QtWidgets.QAction]: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def setActiveDocument(self, value: Document) -> None: ...
    def activeDocument(self) -> Document: ...


class Node(QtCore.QObject):

    def uniqueId(self) -> QtCore.QUuid: ...
    def index(self) -> int: ...
    def setLayerStyleFromAsl(self, asl: str) -> None: ...
    def layerStyleToAsl(self) -> str: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def shearNode(self, angleX: float, angleY: float) -> None: ...
    def cropNode(self, x: int, y: int, w: int, h: int) -> None: ...
    def rotateNode(self, radians: float) -> None: ...
    def scaleNode(self, origin: typing.Union[QtCore.QPointF, QtCore.QPoint], width: int, height: int, strategy: str) -> None: ...
    def mergeDown(self) -> 'Node': ...
    def save(self, filename: str, xRes: float, yRes: float, exportConfiguration: InfoObject, exportRect: QtCore.QRect = ...) -> None: ...
    def duplicate(self) -> 'Node': ...
    def remove(self) -> bool: ...
    def position(self) -> QtCore.QPoint: ...
    def move(self, x: int, y: int) -> None: ...
    def bounds(self) -> QtCore.QRect: ...
    def setPixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], x: int, y: int, w: int, h: int) -> None: ...
    def projectionPixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def pixelDataAtTime(self, x: int, y: int, w: int, h: int, time: int) -> QtCore.QByteArray: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setVisible(self, value: bool) -> None: ...
    def hasKeyframeAtTime(self, frameNumber: int) -> bool: ...
    def visible(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> str: ...
    def parentNode(self) -> 'Node': ...
    def setOpacity(self, value: int) -> None: ...
    def opacity(self) -> int: ...
    def setName(self, value: str) -> None: ...
    def name(self) -> str: ...
    def hasExtents(self) -> bool: ...
    def setLocked(self, value: bool) -> None: ...
    def locked(self) -> bool: ...
    def setInheritAlpha(self, value: bool) -> None: ...
    def inheritAlpha(self) -> bool: ...
    def setColorSpace(self, colorModel: str, colorDepth: str, colorProfile: str) -> bool: ...
    def setColorProfile(self, colorProfile: str) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def setColorLabel(self, value: int) -> None: ...
    def colorLabel(self) -> int: ...
    def collapsed(self) -> bool: ...
    def setCollapsed(self, collapsed: bool) -> None: ...
    def enableAnimation(self) -> None: ...
    def animated(self) -> bool: ...
    def colorDepth(self) -> str: ...
    def setChildNodes(self, nodes: typing.Iterable['Node']) -> None: ...
    def removeChildNode(self, child: 'Node') -> bool: ...
    def addChildNode(self, child: 'Node', above: 'Node') -> bool: ...
    def findChildNodes(self, name: str = ..., recursive: bool = ..., partialMatch: bool = ..., type: str = ..., colorLabelIndex: int = ...) -> typing.List['Node']: ...
    def childNodes(self) -> typing.List['Node']: ...
    def channels(self) -> typing.List[Channel]: ...
    def setBlendingMode(self, value: str) -> None: ...
    def blendingMode(self) -> str: ...
    def setAlphaLocked(self, value: bool) -> None: ...
    def alphaLocked(self) -> bool: ...
    def clone(self) -> 'Node': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class GroupLayer(Node):

    def passThroughMode(self) -> bool: ...
    def setPassThroughMode(self, passthrough: bool) -> None: ...
    def type(self) -> str: ...


class CloneLayer(Node):

    def setSourceNode(self, node: Node) -> None: ...
    def sourceNode(self) -> Node: ...
    def type(self) -> str: ...


class FilterLayer(Node):

    def filter(self) -> Filter: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class FileLayer(Node):

    def path(self) -> str: ...
    def scalingFilter(self) -> str: ...
    def scalingMethod(self) -> str: ...
    def resetCache(self) -> None: ...
    def setProperties(self, FileName: str, ScalingMethod: str, scalingFilter: str) -> None: ...
    def type(self) -> str: ...


class FillLayer(Node):

    def filterConfig(self) -> InfoObject: ...
    def generatorName(self) -> str: ...
    def setGenerator(self, filterName: str, filterConfig: InfoObject) -> bool: ...
    def type(self) -> str: ...


class VectorLayer(Node):

    def createGroupShape(self, name: str, shapes: typing.Iterable[Shape]) -> Shape: ...
    def shapesInRect(self, rect: QtCore.QRectF, omitHiddenShapes: bool = ..., containedMode: bool = ...) -> typing.List[Shape]: ...
    def shapeAtPosition(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> Shape: ...
    def addShapesFromSvg(self, svg: str) -> typing.List[Shape]: ...
    def toSvg(self) -> str: ...
    def shapes(self) -> typing.List[Shape]: ...
    def type(self) -> str: ...


class FilterMask(Node):

    def filter(self) -> Filter: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class SelectionMask(Node):

    def setSelection(self, selection: 'Selection') -> None: ...
    def selection(self) -> 'Selection': ...
    def type(self) -> str: ...


class TransparencyMask(Node):

    def setSelection(self, selection: 'Selection') -> None: ...
    def selection(self) -> 'Selection': ...
    def type(self) -> str: ...


class TransformMask(Node):

    def fromXML(self, xml: str) -> bool: ...
    def toXML(self) -> str: ...
    def finalAffineTransform(self) -> QtGui.QTransform: ...
    def type(self) -> str: ...


class ColorizeMask(Node):

    def setEditKeyStrokes(self, enabled: bool) -> None: ...
    def editKeyStrokes(self) -> bool: ...
    def setShowOutput(self, enabled: bool) -> None: ...
    def showOutput(self) -> bool: ...
    def resetCache(self) -> None: ...
    def updateMask(self, force: bool = ...) -> None: ...
    def limitToDeviceBounds(self) -> bool: ...
    def setLimitToDeviceBounds(self, value: bool) -> None: ...
    def cleanUpAmount(self) -> float: ...
    def setCleanUpAmount(self, value: float) -> None: ...
    def edgeDetectionSize(self) -> float: ...
    def setEdgeDetectionSize(self, value: float) -> None: ...
    def useEdgeDetection(self) -> bool: ...
    def setUseEdgeDetection(self, value: bool) -> None: ...
    def setKeyStrokePixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], color: 'ManagedColor', x: int, y: int, w: int, h: int) -> bool: ...
    def keyStrokePixelData(self, color: 'ManagedColor', x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def transparencyIndex(self) -> int: ...
    def removeKeyStroke(self, color: 'ManagedColor') -> None: ...
    def initializeKeyStrokeColors(self, colors: typing.Iterable['ManagedColor'], transparentIndex: int = ...) -> None: ...
    def keyStrokesColors(self) -> typing.List['ManagedColor']: ...
    def type(self) -> str: ...


class Notifier(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def configurationChanged(self) -> None: ...
    def windowCreated(self) -> None: ...
    def windowIsBeingCreated(self, window: Window) -> None: ...
    def viewClosed(self, view: View) -> None: ...
    def viewCreated(self, view: View) -> None: ...
    def imageClosed(self, filename: str) -> None: ...
    def imageSaved(self, filename: str) -> None: ...
    def imageCreated(self, image: Document) -> None: ...
    def applicationClosing(self) -> None: ...
    def setActive(self, value: bool) -> None: ...
    def active(self) -> bool: ...


class Resource(QtCore.QObject):

    def setImage(self, image: QtGui.QImage) -> None: ...
    def image(self) -> QtGui.QImage: ...
    def filename(self) -> str: ...
    def setName(self, value: str) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Selection(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setPixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], x: int, y: int, w: int, h: int) -> None: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def symmetricdifference(self, selection: 'Selection') -> None: ...
    def intersect(self, selection: 'Selection') -> None: ...
    def subtract(self, selection: 'Selection') -> None: ...
    def add(self, selection: 'Selection') -> None: ...
    def replace(self, selection: 'Selection') -> None: ...
    def selectAll(self, node: Node, value: int) -> None: ...
    def select(self, x: int, y: int, w: int, h: int, value: int) -> None: ...
    def resize(self, w: int, h: int) -> None: ...
    def invert(self) -> None: ...
    def smooth(self) -> None: ...
    def shrink(self, xRadius: int, yRadius: int, edgeLock: bool) -> None: ...
    def grow(self, xradius: int, yradius: int) -> None: ...
    def feather(self, radius: int) -> None: ...
    def border(self, xRadius: int, yRadius: int) -> None: ...
    def dilate(self) -> None: ...
    def erode(self) -> None: ...
    def paste(self, destination: Node, x: int, y: int) -> None: ...
    def cut(self, node: Node) -> None: ...
    def copy(self, node: Node) -> None: ...
    def contract(self, value: int) -> None: ...
    def clear(self) -> None: ...
    def move(self, x: int, y: int) -> None: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def duplicate(self) -> 'Selection': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Preset(QtCore.QObject):

    def __init__(self, resource: Resource) -> None: ...

    def fromXML(self, xml: str) -> None: ...
    def toXML(self) -> str: ...


class PresetChooser(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def presetClicked(self, resource: Resource) -> None: ...
    def presetSelected(self, resource: Resource) -> None: ...
    def currentPreset(self) -> Resource: ...
    def setCurrentPreset(self, resource: Resource) -> None: ...


class Scratchpad(QtWidgets.QWidget):

    def __init__(self, view: View, defaultColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def copyScratchpadImageData(self) -> QtGui.QImage: ...
    def loadScratchpadImage(self, image: QtGui.QImage) -> None: ...
    def setFillColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def setMode(self, modeName: str) -> None: ...
    def linkCanvasZoom(self, value: bool) -> None: ...
    def setModeManually(self, value: bool) -> None: ...
    def clear(self) -> None: ...


class Palette(QtCore.QObject):

    def __init__(self, resource: Resource) -> None: ...

    def save(self) -> bool: ...
    def moveGroup(self, groupName: str, groupNameInsertBefore: str) -> None: ...
    def changeGroupName(self, oldGroupName: str, newGroupName: str) -> None: ...
    def removeEntry(self, index: int, groupName: str) -> None: ...
    def addEntry(self, entry: 'Swatch', groupName: str) -> None: ...
    def colorSetEntryFromGroup(self, index: int, groupName: str) -> 'Swatch': ...
    def colorSetEntryByIndex(self, index: int) -> 'Swatch': ...
    def colorsCountTotal(self) -> int: ...
    def removeGroup(self, name: str, keepColors: bool) -> None: ...
    def addGroup(self, name: str) -> None: ...
    def groupNames(self) -> typing.List[str]: ...
    def setComment(self, comment: str) -> None: ...
    def comment(self) -> str: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...
    def numberOfEntries(self) -> int: ...


class PaletteView(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def entrySelectedBackGround(self, entry: 'Swatch') -> None: ...
    def entrySelectedForeGround(self, entry: 'Swatch') -> None: ...
    def trySelectClosestColor(self, color: 'ManagedColor') -> None: ...
    def removeSelectedEntryWithDialog(self) -> bool: ...
    def addGroupWithDialog(self) -> bool: ...
    def addEntryWithDialog(self, color: 'ManagedColor') -> bool: ...
    def setPalette(self, palette: Palette) -> None: ...


class ManagedColor(QtCore.QObject):

    def __init__(self, colorModel: str, colorDepth: str, colorProfile: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def __ne__(self, other: object): ...
    def toQString(self) -> str: ...
    def fromXML(self, xml: str) -> None: ...
    def toXML(self) -> str: ...
    def setComponents(self, values: typing.Iterable[float]) -> None: ...
    def componentsOrdered(self) -> typing.List[float]: ...
    def components(self) -> typing.List[float]: ...
    def setColorSpace(self, colorModel: str, colorDepth: str, colorProfile: str) -> bool: ...
    def setColorProfile(self, colorProfile: str) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    @staticmethod
    def fromQColor(qcolor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], canvas: typing.Optional[Canvas] = ...) -> 'ManagedColor': ...
    def colorForCanvas(self, canvas: Canvas) -> QtGui.QColor: ...
    def __eq__(self, other: object): ...


class Swatch(PyQt5.sip.wrapper):

    def __init__(self) -> None: ...

    def isValid(self) -> bool: ...
    def setSpotColor(self, spotColor: bool) -> None: ...
    def spotColor(self) -> bool: ...
    def setColor(self, color: ManagedColor) -> None: ...
    def color(self) -> ManagedColor: ...
    def setId(self, id: str) -> None: ...
    def id(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...


class KisCubicCurve(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'KisCubicCurve') -> None: ...

    def fromString(self, a0: str) -> None: ...
    def toString(self) -> str: ...
    def name(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def isConstant(self, x: float) -> bool: ...
    def isIdentity(self) -> bool: ...
    def removePoint(self, idx: int) -> None: ...
    def addPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    def setPoint(self, idx: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setPoints(self, points: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    def points(self) -> typing.List[QtCore.QPointF]: ...
    def value(self, x: float) -> float: ...


from typing import Type


class DockWidgetFactory(DockWidgetFactoryBase):

    def __init__(self, _id: str, _dockPosition: DockWidgetFactoryBase.DockPosition, _klass: Type[DockWidget]): ...


def qDebug(text: str): ...

